'******************************************************************************
' ARP Routines (IP required)
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile                                                  'will compile only as an include file


'-------------------------------------------------------------------------------
' Arp Traffic Filter
'-------------------------------------------------------------------------------
Sub Arp_first_init
     Call Arp_enqueue_ip(my_b_defaultgateway(1))
   #if Include_dns = 1
     Call Arp_enqueue_ip(dns_b_nameserver(1))
   #endif
   #if Include_ntp = 1
     Call Arp_enqueue_ip(ntp_b_server(1))
   #endif
   #if Include_php_call = 1
     Call Arp_enqueue_ip(my_php_server_ip_addr(1))
   #endif
End Sub

'-------------------------------------------------------------------------------
' Arp Traffic Filter
'-------------------------------------------------------------------------------
Sub Arp_packet_filter
    If Arp_b_dest_ip_l <> My_b_ipaddr_l Then Exit Sub
    'ARP is for me
    If Arp_w_op = Arp_w_op_request Then
       Call Arp_request_received
    End If
    If Arp_w_op = Arp_w_op_reply Then
       Call Arp_reply_received
    End If
End Sub

'-------------------------------------------------------------------------------
'  ARP Every Minute
'-------------------------------------------------------------------------------
Sub Arp_every_minute
   Call Arp_cache_decrement_ttl
End Sub

'-------------------------------------------------------------------------------
' Arp Send Request
'-------------------------------------------------------------------------------
Sub Arp_send_request
   Call Clear_buffer
'ETH Header
   Eth_b_dest_mac(1) = &HFF
   Eth_b_dest_mac(2) = &HFF
   Eth_b_dest_mac(3) = &HFF
   Eth_b_dest_mac(4) = &HFF
   Eth_b_dest_mac(5) = &HFF
   Eth_b_dest_mac(6) = &HFF
   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
   Eth_w_packettype = Eth_w_packettype_arp
'ARP Frame
   Arp_w_hwtype = Arp_w_hwtype_ethernet
   Arp_w_prottype = Arp_w_prottype_ipv4
   Arp_b_hwlen = 6
   Arp_b_protlen = 4
   Arp_w_op = Arp_w_op_request
   Arp_b_src_mac(1) = My_b_macaddr(1)
   Arp_b_src_mac(2) = My_b_macaddr(2)
   Arp_b_src_mac(3) = My_b_macaddr(3)
   Arp_b_src_mac(4) = My_b_macaddr(4)
   Arp_b_src_mac(5) = My_b_macaddr(5)
   Arp_b_src_mac(6) = My_b_macaddr(6)
   Arp_b_src_ip(1) = My_b_ipaddr(1)
   Arp_b_src_ip(2) = My_b_ipaddr(2)
   Arp_b_src_ip(3) = My_b_ipaddr(3)
   Arp_b_src_ip(4) = My_b_ipaddr(4)
   Arp_b_dest_mac(1) = &HFF
   Arp_b_dest_mac(2) = &HFF
   Arp_b_dest_mac(3) = &HFF
   Arp_b_dest_mac(4) = &HFF
   Arp_b_dest_mac(5) = &HFF
   Arp_b_dest_mac(6) = &HFF
   Arp_b_dest_ip(1) = Arp_cache_ip1(arp_cache_pointer)
   Arp_b_dest_ip(2) = Arp_cache_ip2(arp_cache_pointer)
   Arp_b_dest_ip(3) = Arp_cache_ip3(arp_cache_pointer)
   Arp_b_dest_ip(4) = Arp_cache_ip4(arp_cache_pointer)
   Call Enc28j60packetsend(arp_packet_length)
#if Debug_arp > 0
   Print
   Print "====================================================================="
   Print "  ARP Request sent for IP " ;
   Call Print_ip(arp_b_dest_ip(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(arp_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_arp > 2
   Call Eth_dump_header
   Call Arp_dump_frame
#endif
End Sub

'-------------------------------------------------------------------------------
' Arp Reply Received
'-------------------------------------------------------------------------------
Sub Arp_reply_received
#if Debug_arp > 0
   Print
   Print "====================================================================="
   Print "  ARP Reply received for IP " ;
   Call Print_ip(arp_b_src_ip(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(arp_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_arp > 2
   Call Eth_dump_header
   Call Arp_dump_frame
#endif
   Call Arp_cache_insert_reply
#if Debug_arp > 0
  Call Arp_dump_cache
#endif

End Sub

'-------------------------------------------------------------------------------
' Arp Request Received
'-------------------------------------------------------------------------------
Sub Arp_request_received
#if Debug_arp > 0
   Print
   Print "====================================================================="
   Print "  ARP Request received for IP " ;
   Call Print_ip(arp_b_dest_ip(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(arp_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_arp > 2
   Call Eth_dump_header
   Call Arp_dump_frame
#endif
    Call Arp_send_reply
End Sub

'-------------------------------------------------------------------------------
' Arp Send Reply
'-------------------------------------------------------------------------------
Sub Arp_send_reply
'The original request packet is in the buffer, we just change some things
'Swap MAC addresses
   Eth_b_dest_mac(1) = Eth_b_src_mac(1)
   Eth_b_dest_mac(2) = Eth_b_src_mac(2)
   Eth_b_dest_mac(3) = Eth_b_src_mac(3)
   Eth_b_dest_mac(4) = Eth_b_src_mac(4)
   Eth_b_dest_mac(5) = Eth_b_src_mac(5)
   Eth_b_dest_mac(6) = Eth_b_src_mac(6)

   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
'Copy target MAC into ARP packet
   Arp_b_dest_mac(1) = Eth_b_dest_mac(1)
   Arp_b_dest_mac(2) = Eth_b_dest_mac(2)
   Arp_b_dest_mac(3) = Eth_b_dest_mac(3)
   Arp_b_dest_mac(4) = Eth_b_dest_mac(4)
   Arp_b_dest_mac(5) = Eth_b_dest_mac(5)
   Arp_b_dest_mac(6) = Eth_b_dest_mac(6)
'Set target IP into ARP packet
   Arp_b_dest_ip(1) = Arp_b_src_ip(1)
   Arp_b_dest_ip(2) = Arp_b_src_ip(2)
   Arp_b_dest_ip(3) = Arp_b_src_ip(3)
   Arp_b_dest_ip(4) = Arp_b_src_ip(4)
'Copy source MAC into ARP
   Arp_b_src_mac(1) = Eth_b_src_mac(1)
   Arp_b_src_mac(2) = Eth_b_src_mac(2)
   Arp_b_src_mac(3) = Eth_b_src_mac(3)
   Arp_b_src_mac(4) = Eth_b_src_mac(4)
   Arp_b_src_mac(5) = Eth_b_src_mac(5)
   Arp_b_src_mac(6) = Eth_b_src_mac(6)
'Set source IP to ARP packet
   Arp_b_src_ip(1) = My_b_ipaddr(1)
   Arp_b_src_ip(2) = My_b_ipaddr(2)
   Arp_b_src_ip(3) = My_b_ipaddr(3)
   Arp_b_src_ip(4) = My_b_ipaddr(4)
'Set ARP type from Request to Reply
   Arp_w_op = Arp_w_op_request
'Send the reply packet
   Call Enc28j60packetsend(arp_packet_length)
#if Debug_arp > 0
   Print
   Print "====================================================================="
   Print "  ARP Reply sent for IP " ;
   Call Print_ip(arp_b_dest_ip(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(arp_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_arp > 2
   Call Eth_dump_header
   Call Arp_dump_frame
#endif
End Sub

'-------------------------------------------------------------------------------
' Arp Enqueue IP
'-------------------------------------------------------------------------------
Sub Arp_enqueue_ip(ip_addr As Byte)
Local Laddr As Word
   If Ip_target_is_on_my_subnet(ip_addr) = 1 Then
      Call Arp_cache_lookup(ip_addr)
#if Debug_arp > 0
    Print "Search in Subnet"
#endif
   Else
      Call Arp_cache_lookup(my_b_defaultgateway(1))
#if Debug_arp > 0
    Print "Search for outside Subnet"
#endif
   End If
   If Arp_cache_pointer > 0 Then                            'found
      If Arp_cache_ttl(arp_cache_pointer) = Arp_cache_ttl_expired Then
         Call Arp_send_request
      End If
   Else                                                     'not found
      Call Arp_cache_lookup_oldest
      Laddr = Varptr(ip_addr) : Arp_cache_ip1(arp_cache_pointer) = Inp(laddr)
      Incr Laddr : Arp_cache_ip2(arp_cache_pointer) = Inp(laddr)
      Incr Laddr : Arp_cache_ip3(arp_cache_pointer) = Inp(laddr)
      Incr Laddr : Arp_cache_ip4(arp_cache_pointer) = Inp(laddr)
      Arp_cache_ttl(arp_cache_pointer) = Arp_cache_ttl_expired
      Call Arp_send_request
   End If
End Sub

'-------------------------------------------------------------------------------
' Arp Cache Get MAC for IP
'-------------------------------------------------------------------------------
Function Arp_request_destmac_for_ip(ip_addr As Byte) As Byte
Local Laddr As Word
Local Lres As Byte
   Lres = Nok
   If Ip_target_is_on_my_subnet(ip_addr) = 1 Then
      Call Arp_cache_lookup(ip_addr)
   Else
      Call Arp_cache_lookup(my_b_defaultgateway(1))
   End If
   If Arp_cache_pointer > 0 Then
      If Arp_cache_ttl(arp_cache_pointer) > Arp_cache_ttl_expired Then
         Eth_b_dest_mac(1) = Arp_cache_mac1(arp_cache_pointer)
         Eth_b_dest_mac(2) = Arp_cache_mac2(arp_cache_pointer)
         Eth_b_dest_mac(3) = Arp_cache_mac3(arp_cache_pointer)
         Eth_b_dest_mac(4) = Arp_cache_mac4(arp_cache_pointer)
         Eth_b_dest_mac(5) = Arp_cache_mac5(arp_cache_pointer)
         Eth_b_dest_mac(6) = Arp_cache_mac6(arp_cache_pointer)
         Call Arp_cache_mark_used(arp_cache_pointer)
         Lres = Ok
      End If
'   Else
      'the MAC from called IP isn't in ARP Cache... so let's do a new call
'      Call Arp_enqueue_ip(ip_addr)
   End If
   Arp_request_destmac_for_ip = Lres
End Function

'-------------------------------------------------------------------------------
' Arp Cache Mark Used
'-------------------------------------------------------------------------------
Sub Arp_cache_mark_used(cacheptr As Byte)
   If Arp_cache_ttl(cacheptr) < Arp_cache_ttl_default Then
      Arp_cache_ttl(cacheptr) = Arp_cache_ttl_used
   End If
End Sub

'-------------------------------------------------------------------------------
' Arp Cache Lookup
'-------------------------------------------------------------------------------
Sub Arp_cache_lookup(ip_addr As Byte)
Local Laddr As Word
   For Arp_cache_pointer = 1 To Arp_cache_size
      Laddr = Varptr(ip_addr)
      If Inp(laddr) = Arp_cache_ip1(arp_cache_pointer) Then
         Incr Laddr
         If Inp(laddr) = Arp_cache_ip2(arp_cache_pointer) Then
            Incr Laddr
            If Inp(laddr) = Arp_cache_ip3(arp_cache_pointer) Then
               Incr Laddr
               If Inp(laddr) = Arp_cache_ip4(arp_cache_pointer) Then
                  Exit Sub
               End If
            End If
         End If
      End If
   Next Arp_cache_pointer
   Arp_cache_pointer = 0
End Sub

'-------------------------------------------------------------------------------
' Arp Cache Decrement
'-------------------------------------------------------------------------------
Sub Arp_cache_decrement_ttl
   For Arp_cache_pointer = 1 To Arp_cache_size
      If Arp_cache_ttl(arp_cache_pointer) > Arp_cache_ttl_expired Then
         Decr Arp_cache_ttl(arp_cache_pointer)
      End If
      If Arp_cache_ttl(arp_cache_pointer) = Arp_cache_ttl_default Then
         Call Arp_send_request
      End If
   Next Arp_cache_pointer
End Sub

'-------------------------------------------------------------------------------
' Arp Cache get oldest
'-------------------------------------------------------------------------------
Sub Arp_cache_lookup_oldest()
Local Lminptr As Byte
Local Lminttl As Byte
Lminptr = 0
Lminttl = 255
   For Arp_cache_pointer = 1 To Arp_cache_size
      If Arp_cache_ttl(arp_cache_pointer) < Lminttl Then
         Lminptr = Arp_cache_pointer
         Lminttl = Arp_cache_ttl(arp_cache_pointer)
      End If
   Next Lb
   Arp_cache_pointer = Lminptr
End Sub

'-------------------------------------------------------------------------------
' Arp Cache Insert Reply
'-------------------------------------------------------------------------------
Sub Arp_cache_insert_reply
   Call Arp_cache_lookup(arp_b_src_ip(1))
   If Arp_cache_pointer = 0 Then
      Call Arp_cache_lookup_oldest()
      Arp_cache_ip1(arp_cache_pointer) = Arp_b_src_ip(1)    ' replace the IP addresses
      Arp_cache_ip2(arp_cache_pointer) = Arp_b_src_ip(2)
      Arp_cache_ip3(arp_cache_pointer) = Arp_b_src_ip(3)
      Arp_cache_ip4(arp_cache_pointer) = Arp_b_src_ip(4)
   End If
   Arp_cache_mac1(arp_cache_pointer) = Arp_b_src_mac(1)     ' rewrite the MAC addresses
   Arp_cache_mac2(arp_cache_pointer) = Arp_b_src_mac(2)
   Arp_cache_mac3(arp_cache_pointer) = Arp_b_src_mac(3)
   Arp_cache_mac4(arp_cache_pointer) = Arp_b_src_mac(4)
   Arp_cache_mac5(arp_cache_pointer) = Arp_b_src_mac(5)
   Arp_cache_mac6(arp_cache_pointer) = Arp_b_src_mac(6)
   Arp_cache_ttl(arp_cache_pointer) = Arp_cache_ttl_default
End Sub

'-------------------------------------------------------------------------------
' Dump ARP Cache
'-------------------------------------------------------------------------------
#if Debug_arp > 0
Sub Arp_dump_cache
Local Li As Integer
   Print
   Print "--------------------------------------------------------------------"
   Print "  Arp Cache"
   Print "--------------------------------------------------------------------"
   Print "Pos  TTL    Mac-Addr              IP-Addr"
   For Li = 1 To Arp_cache_size
       If Li < 10 Then Print " ";                           'padding
       Print Li ; "    " ;
       Print Arp_cache_ttl(li) ; "     " ;
       Print Hex(arp_cache_mac1(li)) ; "-" ; Hex(arp_cache_mac2(li)) ; "-" ; Hex(arp_cache_mac3(li)) ; "-" ;
       Print Hex(arp_cache_mac4(li)) ; "-" ; Hex(arp_cache_mac5(li)) ; "-" ; Hex(arp_cache_mac6(li)) ; "     ";
       Print Arp_cache_ip1(li) ; "." ; Arp_cache_ip2(li) ; "." ; Arp_cache_ip3(li) ; "." ; Arp_cache_ip4(li) ; "   "
   Next Li
   End Sub
#endif

'-------------------------------------------------------------------------------
' Dump ARP Frame
'-------------------------------------------------------------------------------
#if Debug_arp > 2
Sub Arp_dump_frame
    Print "--------------------------------------------------------------------"
    Print "  Arp Frame (28 Bytes)                                        "
    Print "--------------------------------------------------------------------"
    Print "   HW Type: " ; : Call Print_word(arp_w_hwtype , Crlf)
    Print " Prot Type: " ; : Call Print_word(arp_w_prottype , Crlf)
    Print "   HW size: " ; : Call Print_byte(arp_b_hwlen , Crlf)
    Print " Prot size: " ; : Call Print_byte(arp_b_protlen , Crlf)
    Print "    Opcode: " ; : Call Print_word(arp_w_op , Crlf)
    Print "Source Mac: " ; : Call Print_mac(arp_b_src_mac(1) , Crlf)
    Print "Source  IP: " ; : Call Print_ip(arp_b_src_ip(1) , Crlf)
    Print " Dest. MAC: " ; : Call Print_mac(arp_b_dest_mac(1) , Crlf)
    Print " Dest.  IP: " ; : Call Print_ip(arp_b_dest_ip(1) , Crlf)
End Sub
#endif